
# exs.py
# Andrew Davison, ad@coe.psu.ac.th, August 2025

'''
Questions 4, 5, 6, 7

What quaternion represents a rotation through $60^\circ$ about the $x$-axis?

What rotation does the quaternion $\mbf{q} = 0.707 + 0.189\mbf{i} + 0.378\mbf{j} + 0.567\mbf{k}$ represent?

Consider a rotation through $30^\circ$ about $(0,1,0)$. Find the new position under this rotation of the point $\mbf{v} = (3,4,5)$ using quaternions.
  
Find a single rotation that is equivalent to the following sequence of rotations: a rotation through $50^\circ$ about the axis $(1,2,4)$, followed by a rotation through $37^\circ$ about the axis $(2,-1,2)$.
'''

import math
from Vec import Vec
from Quat import Quat


x = Vec(1, 0, 0)
print( Quat.fromAxisAngle(x, math.pi/3))
print()

q = Quat(0.707, Vec(0.189, 0.378, 0.567))
axis, angle = q.toAxisAngle()
ang = round(math.degrees(angle), 1)  
print("Axis:", axis, "; angle:", ang)
print()

y = Vec(0, 1, 0)
v1 = Vec(3,4,5)
q = Quat.fromAxisAngle(y, math.pi/6)
v2 = q.rotateVec(v1)
print(f"Rotate {v1} around {q}...")
print("Result:", v2)
print()

q1 = Quat.fromAxisAngle(Vec(1,2,4), math.radians(50))
q2 = Quat.fromAxisAngle(Vec(2,-1,2), math.radians(37))
q = q2*q1
print("q:", q)
axis, angle = q.toAxisAngle()
ang = round(math.degrees(angle), 1)  
print("Axis:", axis, "; angle:", ang)
print()
