
# havDiff.py

import math
import matplotlib.pyplot as plt
import nav

meterDegree = 2 * math.pi * nav.EARTH_RADIUS * 1000 / 360
  # average meters per degree latitude

# location
startCity = input("Start city? ").title()
cities = nav.loadCityData()
lat1, lon1 = nav.readCoord(cities, startCity) 
print(f"{startCity} (lat,lon): ({lat1:.2f}, {lon1:.2f})")

# Distances from 1 to 1000m in steps of 5
dists = list(range(1, 1001, 5))
errs = []

for dist in dists:
  lat2 = lat1 + dist/meterDegree
  dCos = nav.distTo(lat1, lon1, lat2, lon1)  # same longitude
  dHav = nav.havDistTo(lat1, lon1, lat2, lon1)
  errs.append(abs(dHav - dCos)*1000)  # in meters


plt.figure(figsize=(10, 5))

plt.plot(dists, errs, label='Abs error (meters)', color='blue')
plt.yscale('log')

plt.xlabel('True distance between points (meters)')
plt.ylabel('|Haversine - Cosine| (meters, log scale)')
plt.title(f'Haversine vs. Cosine Dist ({startCity})')
plt.grid(True, which='both', ls='--', lw=0.5)
plt.legend()
plt.tight_layout()
plt.show()
	
