
# ehCycloid.py
# Andrew Davison, ad@coe.psu.ac.th, Dec. 2025
# input:  -2 1   2    3   4  2.1  3.8   5.5  7.2


import math, random
import matplotlib.pyplot as plt
from frange import linspace


ratio = float(input("R/r value? "))

nRots = 10
n = 1000
rsmall = 1.0
ts = linspace(0, 2*math.pi*nRots, n)
xs = [rsmall*(1+ratio)*math.cos(t) -  \
      rsmall*math.cos((1+ratio)*t) for t in ts]
ys = [rsmall*(1+ratio)*math.sin(t) -  \
      rsmall*math.sin((1+ratio)*t) for t in ts]

plt.plot(xs, ys)
plt.axis('equal')
plt.title(f"R/r={ratio:.2f}")
plt.show() 



