
# astroid.py
# Andrew Davison, ad@coe.psu.ac.th, Dec. 2025

import math
import matplotlib.pyplot as plt


def astroid(a, nPts):
  ts = [2 * math.pi * i / nPts for i in range(nPts + 1)]
  xs = [a * (math.cos(t) ** 3) for t in ts]
  ys = [a * (math.sin(t) ** 3) for t in ts]
  return xs, ys


# --------------------------------
a = 1.0
nPts = 1000

xs, ys = astroid(a, nPts)

fig, ax = plt.subplots()
ax.plot(xs, ys, linewidth=2)

# Use spines as axes through the origin
ax.spines["left"].set_position("zero")
ax.spines["bottom"].set_position("zero")
ax.spines["right"].set_color("none")
ax.spines["top"].set_color("none")

ax.set_aspect("equal", adjustable="box")
ax.set_xlim(-1.2 * a, 1.2 * a)
ax.set_ylim(-1.2 * a, 1.2 * a)

ax.set_xlabel("x")
ax.set_ylabel("y")
ax.xaxis.set_label_coords(1.02, 0.52)
ax.yaxis.set_label_coords(0.52, 1.02)

plt.show()
