
# plot2D.py
# Andrew Davison, ad@coe.psu.ac.th, Nov. 2025

# Generate a 2D plot of a cubic

import cubicUtils
import matplotlib.pyplot as plt


a, b, c, d = map(float, input("Enter cubic coefs (a b c d): ").split())
size = int(input("Range (or 3): ") or "3")

xMin, xMax = -size, size
print(f"Range: [{xMin}, {xMax}]")

xs = cubicUtils.linspace(xMin, xMax, 150)
ys = [ cubicUtils.cubic(x, a, b, c, d) for x in xs]

fig, ax = plt.subplots()
ax.plot(xs, ys)

ax.spines['left'].set_position('zero')
ax.spines['bottom'].set_position('zero')
ax.spines[['top', 'right']].set_visible(False)
ax.set_xlabel('x', loc='right')
ax.set_ylabel('f(x)', loc='top')

ax.grid(True, alpha=0.3, ls='--')
ax.set_title( cubicUtils.toString(a, b, c, d))
plt.tight_layout()
plt.show()