
# paramPlot.py
# Andrew Davison, ad@coe.psu.ac.th, Oct. 2025
# command line inputs: lspiral.txt  parabola.txt
'''
Read parameters from a text file supplied on the command line
e.g.
   python paramPlot.pt parabola.txt

parabola.txt contains:

title = parabola

x = t
y = a*t**2

tMin = -5
tMax = 5
step = 0.1

The parameterized equation are the two lines x = ... and y = ...
and the range of values for t are set with tMin, tMax, and step.
The title line is used in the plot.

Then display the parameterized plot together with two sliders
for 'a' and 'b' variables which may be optionally included
in the parameterized equation. For the parabola, I've only used 'a'.
'''

import math, sys
import matplotlib.pyplot as plt
import paramUtils

def update(val):
  global a, b
  a = aSlider.val
  b = bSlider.val
  curve.set_xdata( paramUtils.evalEqu(xEqu, a, b, ts))
  curve.set_ydata( paramUtils.evalEqu(yEqu, a, b, ts))
  ax.relim()
  ax.autoscale_view()
  fig.canvas.draw_idle()




# ------------------------------------

if len(sys.argv) != 2:
  print("Usage: python paramPlot.py <fnm>")
  sys.exit(1)
title, a, b, xEqu, yEqu, zEqu, ts = paramUtils.parseEqus(sys.argv[1])

fig, ax = plt.subplots(figsize=(6,6))
plt.subplots_adjust(left=0.25, bottom=0.25)

# Initial evaluation of x and y
xs = paramUtils.evalEqu(xEqu, a, b, ts)
ys = paramUtils.evalEqu(yEqu, a, b, ts)
curve, = ax.plot(xs, ys, label=f"x = {xEqu}\ny = {yEqu}")

ax.set_xlabel('x')
ax.set_ylabel('y')
ax.set_title(title)
ax.axis('equal')
plt.legend(loc='upper left')

aSlider, bSlider = paramUtils.addSliders(a, b)
aSlider.on_changed(update)
bSlider.on_changed(update)

plt.show()
