
# sinhCosh.py
# Andrew Davison, Nov 2025, ad@coe.psu.ac.th

import math
import matplotlib.pyplot as plt

xs = [i * 0.01 for i in range(-400, 401)]
sinhs = [(math.exp(x) - math.exp(-x)) / 2 for x in xs]
coshs = [(math.exp(x) + math.exp(-x)) / 2 for x in xs]
exps = [math.exp(x) for x in xs]
negExps = [math.exp(-x) for x in xs]

fig, ax = plt.subplots(figsize=(8, 6))

# show x and y axes placed at zero
ax.spines['left'].set_position('zero')
ax.spines['bottom'].set_position('zero')
ax.spines['right'].set_color('none')
ax.spines['top'].set_color('none')

expLn, = ax.plot(xs, exps, color='black', label='$e^x$', ls='--')
expLn.set_dashes([5, 3])  # Dash pattern: 5 on, 3 off

expLn2, = ax.plot(xs, negExps, color='black', label='$e^{-x}$', ls='--')
expLn2.set_dashes([1, 3, 5, 3])  
    # Dash pattern: 1 on, 3 off, 5 on, 3 off

ax.plot(xs, sinhs, label='sinh(x)')
ax.plot(xs, coshs, label='cosh(x)')

ax.set_xlim(-4, 4)
ax.set_ylim(-2, 4)
ax.set_title('Plot of sinh, cosh, $e^x$, and $e^{-x}$')
ax.legend()
ax.grid(True, which='both', ls=':', linewidth=0.5)

plt.show()
