
# paraTractrix.py
# Andrew Davison, Nov 2025, ad@coe.psu.ac.th

import math
import matplotlib.pyplot as plt


usRight = [i * 0.01 for i in range(0, 801)]     # 0 <= u <= 8
usLeft  = [-i * 0.01 for i in range(0, 801)]    # -8 <= u <= 0

# points for the right branch
xsRight = [u - math.tanh(u) for u in usRight]
ysRight = [1.0 / math.cosh(u) for u in usRight]

# points for the left branch
xsLeft = [u - math.tanh(u) for u in usLeft]
ysLeft = [1.0 / math.cosh(u) for u in usLeft]

fig, ax = plt.subplots()

ax.plot(xsRight, ysRight)
ax.plot(xsLeft, ysLeft)

# spines as axes
ax.spines["left"].set_position("zero")
ax.spines["bottom"].set_position("zero")
ax.spines["right"].set_color("none")
ax.spines["top"].set_color("none")

ax.set_xlabel("x")
ax.set_ylabel("y")
ax.set_title("Tractrix:  x = u − tanh(u),  y = sech(u)")
ax.grid(True, which="both", linestyle="--", lw=0.5)

plt.show()
