
# urnsN.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th

'''
  inputs:
      N = 5 or 10
      q = 0.5
'''

from MarkovLib import *


N = int(input("N? "))
q = float(input("q=? "))

m = [[0.0 for _ in range(N+1)] for _ in range(N+1)]

for n in range(1, N):
  m[n][n-1] = n*q/N
  m[n][n] = 1-q
  m[n][n+1] = (N-n)*q/N

m[0][0] = 1-q
m[0][1] = q

m[N][N-1] = q
m[N][N] = 1-q

urnsN = Mat(m)
labels = list(map(str, range(N+1)))

print("urnsN:")
matLabels(urnsN, labels)

graph("urnsN", labels, urnsN)


pow = int(input("Power n: "))   # 40
powers(labels, urnsN, pow)

'''
Z, w, n, M = steady(urnsN)
print("Fundamental matrix Z:")
matLabels(Z, labels)

print("Fixed Vector / Stationary Distribution w:")
vecLabels(w, labels, fmt="{:.4f}")

print("Mean Recurrence Times n:")
vecLabels(n, labels)

print("Mean First Passage Times M:")
matLabels(M, labels, labels)
'''
