
# simMarkov.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th

# inputs: OzWeather, urns5, maze, drunk

import random
from MarkovLib import *

NUM_RUNS = 50
RUN_LEN = 20

fnm = input("fnm? ")
labels, P = readMarkov(fnm)
print("P:")
matLabels(P, labels)
# graph(fnm, labels, P)

p = P.data
n = len(labels)
count = [0] * n   # count of states visited
for _ in range(NUM_RUNS):
  print("> ", end=' ')
  currState = random.choice(range(n)) # random start
  for _ in range(RUN_LEN):
    r = random.random()   
    for j in range(n):
      # decrement prob from r until it reaches 0 (or less)
      r -= p[currState][j]
      if r < 0:  # what state are we in?
        currState = j
        print(labels[currState], end=' ')
        break
    count[currState] += 1
  print()

print("\n\nLabel  Counts  Fraction")
totSteps = NUM_RUNS*RUN_LEN
for i in range(n):
  print(f"{labels[i]:<7}{count[i]:<8}{(count[i] / totSteps):.3f}")
