
# absorbTests.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th
# inputs:  drunk6  tennis  spinner


from MarkovLib import *


def getQR(P, pLabels):
  ''' Split P into Q and R assuming 
    that the first and last states
    are the absorbing ones.
  '''
  last = P.nRows-1
  qIndices = list(range(1, last))
  Q = P.submatrix(qIndices, qIndices)
           # transient -> transient
  qLabels = pLabels[1:last]
  
  R = P.submatrix(qIndices, [0, last])
           # transient -> absorbing
  rLabels = [pLabels[0], pLabels[last]]
  
  return Q, qLabels, R, rLabels



fnm = input("fnm? ")
pLabels, P = readMarkov(fnm)
print("P:")
matLabels(P, pLabels)
graph(fnm, pLabels, P)

Q, qLabels, R, rLabels = getQR(P, pLabels)
print("Q:")
matLabels(Q, qLabels)
print("R:")
matLabels(R, qLabels, rLabels)


N, B, t = absorb(Q, R)
print("Fundamental Matrix N:")
matLabels(N, qLabels)

print("Expected Times to Absorption t:")
matLabels(t, qLabels, [""])

print("Absorption Probs Matrix B:")
matLabels(B, qLabels, rLabels)


