
# absorbSnakes.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th
'''
Exercise 5

    1  2  3  4  5  6  7  8
1        0.5         0.5
2           0.5 0.5
3           0.5 0.5
4  0.5          0.5
5  0.5               0.5
6
7           0.5
8
'''

from Mat import *
from MarkovLib import *


qLabels = ["1", "2", "3", "4", "5", "6", "7", "8"]

Q = Mat.fillSq(8, 0)
Q[0][2] = 0.5; Q[0][6] = 0.5
Q[1][3] = 0.5; Q[1][4] = 0.5
Q[2][3] = 0.5; Q[2][4] = 0.5
Q[3][0] = 0.5; Q[3][4] = 0.5
Q[4][0] = 0.5; Q[4][6] = 0.5
Q[6][3] = 0.5
print("Q:")
matLabels(Q, qLabels)

rLabels = ["9"]
R = Mat.fill(8,1,0)
R[6][0] = 0.5
print("R:")
matLabels(R, qLabels, rLabels)


N, B, t = absorb(Q, R)
print("Fundamental Matrix N:")
matLabels(N, qLabels)

print("Expected Times to Absorption t:")
matLabels(t, qLabels, [""])

print("Absorption Probs Matrix B:")
matLabels(B, qLabels, rLabels)

