
# absorbFair.py
# Andrew Davison, June 2025, ad@coe.psu.ac.th
'''
fair.txt
exercise 6

labels: 0 H HT HTH HTHH

0.5  0.5   0   0   0
 0   0.5  0.5  0   0
0.5   0    0  0.5  0
 0    0   0.5  0  0.5
 0    0    0   0   1
'''

from Mat import *
from MarkovLib import *


pLabels, P = readMarkov("fair")
print("P:")
matLabels(P, pLabels)
graph("fair", pLabels, P)

# split matrix assuming absorbing state is in last row
last = P.nRows-1
qIndices = list(range(0, last))
Q = P.submatrix(qIndices, qIndices)
         # transient -> transient
qLabels = pLabels[0:last]

R = P.submatrix(qIndices, [last])
         # transient -> absorbing
rLabels = [pLabels[last]]

print("Q:")
matLabels(Q, qLabels)
print("R:")
matLabels(R, qLabels, rLabels)


N, B, t = absorb(Q, R)
print("Fundamental Matrix N:")
matLabels(N, qLabels)

print("Expected Times to Absorption t:")
matLabels(t, qLabels, [""])

print("Absorption Probs Matrix B:")
matLabels(B, qLabels, rLabels)

