
# ifs.py
# https://introcs.cs.princeton.edu/python/22module/index.php#2.2.4
# https://www.cut-the-knot.org/ctk/ifs.shtml

# input: ".txt" file in ifs/
'''
  sierpinski
  barnsley
  coral
  culcita
  cyclosorus
  dragon
  fishbone
  floor
  koch
  spiral
  swirl
  tree
  zigzag
'''

# Read a 1-by-m vector (probs) and two m-by-3 matrices (coeffs)
# for updating x and y from a text file. 
# Plot the results as a set of N points

import random
import matplotlib.pyplot as plt
from reader import *

SCR_WIDTH = 600
SCR_HEIGHT = 600
N = 10000

fnm = input("fnm=? ")
reader = readVals("ifs/"+fnm+".txt")
probs = readFloat1D(reader)
print("probs:", probs)
cx = readFloat2D(reader)
print("\ncx:", *cx)
cy = readFloat2D(reader)
print("\ncy:", *cy)

xs = []; ys = []
x = 0.0; y = 0.0
for i in range(N):
  els = random.choices(range(len(probs)), weights=probs)
  r = els[0]
  x0 = cx[r][0]*x + cx[r][1]*y + cx[r][2]
  y0 = cy[r][0]*x + cy[r][1]*y + cy[r][2]
  x = x0; y = y0
  # print(x,y)
  xs.append( (x*SCR_WIDTH) % SCR_WIDTH)
  ys.append( (y*SCR_HEIGHT) % SCR_HEIGHT)
  

plt.scatter(xs, ys, s=1)
plt.axis('off')
plt.title("IFS for " + str(fnm))
plt.show()

