
# sicherman.py
'''
Introduction to Programming in Python
Robert Sedgewick, Kevin Wayne, Robert Dondero
Addison-Wesley, 2015
Ex 2.2.14 Sichermun dice
https://introcs.cs.princeton.edu/python/22module/

https://en.wikipedia.org/wiki/Sicherman_dice


Suppose that you have two six-sided dice, one with faces labeled 1, 3, 4, 5, 6, and 8 and the other with faces labeled 1, 2, 2, 3, 3, and 4. Compare the probabilities of occurrence of each of the values of the sum of the dice with those for a standard pair of dice. 

Sicherman dice produce sums with the same frequency as regular dice (2 with probability 1/36, 3 with probability 2/36, and so on).

'''

import random

N = 100000
MAX_SCORE = 12


def rollSicherman():
  dice1 = random.choice([1,3,4,5,6,8])
  dice2 = random.choice([1,2,2,3,3,4])
  return dice1+dice2

def rollNormal():
  dice1 = random.randint(1,6)
  dice2 = random.randint(1,6)
  return dice1+dice2


sichRolls = [0]*(MAX_SCORE+1)
normRolls = [0]*(MAX_SCORE+1)

for roll in range(N):
  sichRolls[ rollSicherman()] += 1
  normRolls[ rollNormal()] += 1


print("Score   Norm    Sicherman")
for i in range(2, MAX_SCORE+1):
  print(f"{i:4d}   {normRolls[i]/N:.4f}    {sichRolls[i]/N:.4f}")
