
# randScatter.py
'''

https://stackoverflow.com/questions/5837572/generate-a-random-point-within-a-circle-uniformly/50746409#50746409

https://extremelearning.com.au/how-to-generate-uniformly-random-points-on-n-spheres-and-n-balls/

'''

import random, math
import matplotlib.pyplot as plt

NUM_PTS = 1000

circle = plt.Circle((0, 0), 1, color="red", alpha=0.5)
plt.gca().add_patch(circle)


xs = [0]*NUM_PTS
ys = [0]*NUM_PTS
for i in range(NUM_PTS):
  r = random.random()**0.5  # for uniformity
  theta = 2*math.pi*random.random()
  xs[i] = r*math.cos(theta)
  ys[i] = r*math.sin(theta)

plt.scatter(xs, ys, s=5)  # s is point size

plt.axis('scaled')
plt.title("Random Polar Coordinates")
plt.show()
