
"""
 OBTUSE estimates the probability that a random triangle is obtuse.

   We generate a "random" triangle as half of a rectangle whose
   height is 1, and whose width is 1 <= L.

   Paul Nahin,
   Digital Dice: Computational Solutions to Practical Probability Problems,
   Princeton, 2008,
   Intro, p.11
"""

import random, math

NUM_ITERS = 100000

length = int(input("length=? "))

sum = 0
for k in range(NUM_ITERS):
  xs = [ random.random() for i in range(3)]
  ys = [ length * random.random() for i in range(3)]

  # calculate square lengths
  d1 = (xs[0] - xs[1])**2 + (ys[0] - ys[1])**2
  d2 = (xs[1] - xs[2])**2 + (ys[1] - ys[2])**2
  d3 = (xs[2] - xs[0])**2 + (ys[2] - ys[0])**2

  if (d1 < d2 + d3) and (d2 < d1 + d3) and (d3 < d1 + d2):
    obtuseTriangle = 0  # not obtuse
  else:
    obtuseTriangle = 1
  sum += obtuseTriangle


print("Estimated likelihoood of obtuse triangle:", (sum/NUM_ITERS))
print("For length=1, expected value:", 97/150 + math.pi/40)
print("For length=2, expected value:", 1199/1200 + 13*math.pi/128 - 0.75 * math.log(2))

