
# stirling.py

# calculate factorial of a number using 
# Stirling Approximation 
# https://econowmics.com/kattis-stirlings-approximation/

import math 


def stirlingFact(n): 
  if (n == 1): 
    return 1
  	
  z = (math.sqrt(2 * math.pi * n) * math.pow((n / math.e), n)) 
  return math.floor(z) 


# ---------- main --------------

for i in range(1, 16):
  f = math.factorial(i)
  sf = stirlingFact(i)
  err = (sf -f)/f
  print(i, f, sf, err)
