
# stirling-q6
# Add. Exs for Section 1 to 18, Q.6

# Stirling numbers of the first kind count permutations according 
# to their number of cycles

# info: https://en.wikipedia.org/wiki/Stirling_numbers_of_the_first_kind
# input: 9 3 or 8 2

def stirling1(n, k):
  # no. of permutations of {1, 2, ... n} with k cycles
  if k == 1:
    return factorial(n-1)
  if n == k:
    return 1
  if n < k:
    return 0
  return stirling1(n-1, k-1) + (n-1)*stirling1(n-1, k)
  
def factorial(k):
  res = 1
  if k <= 1:
    return res
  for i in range(1, k+1):
    res *= i
  return res
  
n,k = map(int, input("n k=? ").split())
print(stirling1(n, k))
