
# hofstadter.py

'''
Recursive functions (with memoization)

Q-sequence (meta-Fibonacci sequence):
Q(n) = 1              if n = 1 or 2
Q(n) = Q(n - Q(n-1)) + 
       Q(n - Q(n-2)   if n > 2

G–sequence:
G(0) = 0
G(n) = n − G(G(n − 1)) for n > 0


Married functions:
F(n) = n - M(F(n-1))  if n > 0
M(n) = n - F(M(n-1))  if n > 0
F(n) = 1  if n = 0
M(n) = 0  if n = 0

Hofstadter, D., Gödel, Escher, Bach: An Eternal Golden Braid, 
Penguin Books, 1979
p.137 

https://www.fq.math.ca/Papers1/46_47-1/Stoll_11-08.pdf
https://craftofcoding.wordpress.com/2021/06/04/recursion-the-hofstadter-sequences/

'''

import matplotlib.pyplot as plt


N = 100

qMemo = [0, 1, 1]
def q(n):
  if n < len(qMemo):
    return qMemo[n]
  else:
    result = q(n - q(n-1)) + q(n - q(n-2))
    qMemo.append(result)
    return result


gMemo = [0]
def g(n):
  if n < len(gMemo):
    return gMemo[n]
  else:
    result = n - g(g(n-1))
    gMemo.append(result)
    return result


mMemo = [0]
def m(n):
  if n < len(mMemo):
    return mMemo[n]
  else:
    result = n - f(m(n-1))
    mMemo.append(result)
    return result

fMemo = [0]
def f(n):
  if n < len(fMemo):
    return fMemo[n]
  else:
    result = n - m(f(n-1))
    fMemo.append(result)
    return result




plt.plot(range(1, N), [q(i) for i in range(1,N)], alpha=0.5, label="q")
plt.plot(range(N), [g(i) for i in range(N)], alpha=0.5, label="g")
plt.plot(range(N), [m(i) for i in range(N)], alpha=0.5, label="m")
plt.plot(range(N), [f(i) for i in range(N)], alpha=0.5, label="f")
plt.legend()
plt.title("Hofstadter Functions")
plt.show()