
# tableaux.py

'''
Introduction to Programming in Python
Robert Sedgewick, Kevin Wayne, Robert Dondero
Addison-Wesley, 2015
Ex 4.1.32 Young tableaux
https://introcs.cs.princeton.edu/python/41analysis/

Suppose you have in memory an n-by-n grid of integers a[][] 
such that a[i][j] < a[i+1][j] and a[i][j] < a[i][j+1] for 
all i and j, like the table below.

     5 23 54 67 89
     6 69 73 74 90
    10 71 83 84 91
    60 73 84 86 92
    90 91 92 93 94

Devise an algorithm whose order of growth is linear in n to 
determine whether a given integer x is in a given Young tableaux.

Solution: Start at the upper-right corner. If the value is x, return True. 
Otherwise, go left if the value is greater than x and go down if the 
value is less than x. If you reach bottom left corner, then x is not 
in table. The algorithm is linear because you can go left at most n 
times and down at most n times.
'''


mat = [[ 5, 23, 54, 67, 89 ],
       [ 6, 69, 73, 74, 90 ],
       [10, 71, 83, 84, 91 ],
       [60, 73, 84, 86, 92 ],
       [90, 91, 92, 93, 94 ]]

numRows = len(mat)
numCols = len(mat[0])

def find(x, mat):
  c = numCols-1; r = 0
  while (0 <= c < numCols) and (0 <= r < numRows):
    if mat[r][c] == x:
      return True
    elif mat[r][c] > x:
      c -= 1    # go left
    else:
      r += 1    # go down
  return False


print("Find 84:", find(84, mat))
print("Find 88:", find(88, mat))
print("Find 1:", find(1, mat))

