
# majority.py

'''
Introduction to Programming in Python
Robert Sedgewick, Kevin Wayne, Robert Dondero
Addison-Wesley, 2015
Ex 4.2.26 Majority
https://introcs.cs.princeton.edu/python/41analysis/

Given an array of elem elements, an element is a majority if it 
appears more than elem/2 times. Compose a function that takes an 
array of elem strings as an argument and identifies a majority 
(if it exists) in linear time.

https://www.geeksforgeeks.org/majority-element/
https://www.geeksforgeeks.org/python-counter-majority-element/

Convert given list of elements into a dictionary, having elements 
as keys and their frequencies as value.

Now traverse complete dictionary and check for element whose 
frequency follows the condition greater than (elem/2) where elem is size of list. 
That element will be majority element.

https://stackoverflow.com/questions/20038011/trying-to-find-majority-element-in-a-list


'''

def findMajority(arr):
  maxInfo = ('', 0)    # (element, no. of occurrences)

  dict = {}
  for elem in arr:
    if elem in dict: 
      dict[elem] += 1
    else: 
      dict[elem] = 1

    # Keep track of maximum
    if dict[elem] > maxInfo[1]: 
      maxInfo = (elem, dict[elem])

  return maxInfo


arr = [1,2,3,4,3,3,2,4,5,6,1,2,3,4,5,1,2,3,4,6,5]
print(arr)

maxInfo = findMajority(arr)
print("Max element:", maxInfo[0], "; no. of occurrences:", maxInfo[1])

