
# lattice-q20
# Add. Exs for Sections 1-65, Q.20

import os
os.environ['PYGAME_HIDE_SUPPORT_PROMPT'] = "hide"
import pygame
 
# some colors
BLACK = (0, 0, 0)
WHITE = (255, 255, 255)
GRAY = (100, 100, 100)
GREEN = (0, 255, 0)
RED = (255, 0, 0)

SIDES = 70   # number of dots along a side
SIZE = 3  # size of each dot
MARGIN = 8   # space between dots

MAX_SEQ = 20000


def expand(seq):
  nseq = []
  for pair in seq:
    nseq.append(pair)
    x = pair[0]; y = pair[1]
    p1 = (2*x, y)
    if not (p1 in seq):
      nseq.append(p1)
    p2 = (x, 2*y)
    if not (p2 in seq):
      nseq.append(p2)
    if x > y:
      p3 = (x-y,y)
    elif x < y:    # not ==
      p3 = (x, y-x)
    else:
      p3 = (x, y)  # unchanged
    if not (p3 in seq):
      nseq.append(p3)

  return nseq


def updateGrid(seq):
  for pair in seq:
    x = pair[0]; y = pair[1]
    if (x >= 0) and (x < SIDES) and \
       (y >= 0) and (y < SIDES):
      grid[x][y] = True


def drawGrid(screen, grid):
  # Draw the grid
  for row in range(SIDES):
    for column in range(SIDES):
      color = GREEN if grid[row][column] else GRAY
      pygame.draw.circle(screen, color,
          ((MARGIN + SIZE)*column + MARGIN,
           (MARGIN + SIZE)*row + MARGIN), SIZE)

 

# grid[x][y]
grid = [[False for y in range(SIDES)] for x in range(SIDES)]
  
pygame.init()
 
screen = pygame.display.set_mode([800, 800])
pygame.display.set_caption("Lattice")
 
isRunning = True
clock = pygame.time.Clock()

seq = [(1,1)]

while isRunning:
  clock.tick(60)

  for event in pygame.event.get(): 
    if event.type == pygame.QUIT:  
      isRunning = False  
    elif event.type == pygame.MOUSEBUTTONDOWN:
      pos = pygame.mouse.get_pos()
      column = pos[0] // (SIZE + MARGIN)
      row = pos[1] // (SIZE + MARGIN)
      print("Grid coordinates: ", row, column)

  if len(seq) < MAX_SEQ:
    seq = expand(seq)
    updateGrid(seq)

  screen.fill(BLACK)
  drawGrid(screen, grid)
  pygame.display.update()
 
pygame.quit()
