
# golombRuler.py
# inputs: 4 6 or 5 11 or 6 17

# https://en.wikipedia.org/wiki/Golomb_ruler
# https://github.com/abdessalem-aghrib/golomb-problem-metaheuristic-project

import random


def isGolomb(ruler):
  numMarks = len(ruler)

  if ruler[0] != 0:
    return False

  for item in ruler:
    if item < 0:
      return False

  # build and check differences table
  diffs = []
  for i in range(numMarks-1):
    d = ruler[i+1] - ruler[i]
    if diffs.__contains__(d):
      return False
    diffs.append(d)

  index = numMarks - 2
  diffLen = 2
  for i in range(index, 0, -1):
    for j in range(i):
      d = 0
      for k in range(diffLen):
        d += diffs[k + j]
      if diffs.__contains__(d):
        return False
      diffs.append(d)
    diffLen += 1

  # case of two identical marks
  if diffs.__contains__(0):
    return False

  return True


# main --------------------

numMarks,length = map(int, input("numMarks, ruler length=? ").split())
ruler = [0]*numMarks


while not isGolomb(ruler):
  for v in range(numMarks - 1):
    # generate a random value that not exist in new ruler
    val = random.randint(1, length)
    while ruler.__contains__(val):
      val = random.randint(1, length)
    ruler[v + 1] = val
  ruler.sort()

print(*ruler)