
# farey.py
# https://code.activestate.com/recipes/52317/
# https://code.activestate.com/recipes/496821-farey-sequence/

# http://mathworld.wolfram.com/FareySequence.html

'''
  No error checking on args -- lim = max denominator,
  results are (numerator, denominator), (1,0) is infinity
'''


def farey(v, lim):
  if v < 0:
    n, d = farey(-v, lim)
    return -n, d

  z = lim-lim	# get 0 of right type for denominator
  lower, upper = (z,z+1), (z+1,z)

  while True:
    mediant = (lower[0] + upper[0]), (lower[1]+upper[1])
    if v * mediant[1] > mediant[0]:
      if lim < mediant[1]: 
        return upper
      lower = mediant
    elif v * mediant[1] == mediant[0]:
      if lim >= mediant[1]: 
        return mediant
      if lower[1] < upper[1]: 
        return lower
      return upper
    else:
      if lim < mediant[1]: 
        return lower
      upper = mediant



# ---------- main ----------------------

print(farey(0.584115140346, 100) )
# (7, 12)

print(farey(0.584115140346, 1000) )
# (125, 214)

print(farey(0.584115140346, 10000) )
# (5479, 9380)

print(farey(0.584115140346, 100000) ) 
# (37419, 64061)
