
# letter3d.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
  Define coordinates and faces for a 3D "R" shape
  (more like a rectangle and a triangle).

  The R is resting on its back on the XY plane,
  with the bottom, left corner at the origin.

  The following transformations are carried out:
     * X-axis rotation by 90 degrees (to make the 'R'
       stand of the XY plane);

     * Z-axis rotation by 30 degrees (turns the 'R'
       counterclockwise around the XY plane;

     * scale by 4 (i.e. it will now be 4 units high);

     * translate the shape's origin to (-1, 1, -3),
       moving the rest of the shape in the process.

'''

import matplotlib.pyplot as plt
from mpl_toolkits.mplot3d.art3d import Poly3DCollection
from HC3Mat import *


# vertices for R shape
verts = [
  # Bottom (z = 0)
  (0.0, 0.0, 0.0),  # 0
  (0.0, 1.0, 0.0),  # 1 
  (0.6, 1.0, 0.0),  # 2 
  (0.6, 0.6, 0.0),  # 3 
  (0.0, 0.6, 0.0),  # 4 
  (0.6, 0.0, 0.0),  # 5

  # Top (z = 0.3)
  (0.0, 0.0, 0.3),  # 6
  (0.0, 1.0, 0.3),  # 7
  (0.6, 1.0, 0.3),  # 8
  (0.6, 0.6, 0.3),  # 9
  (0.0, 0.6, 0.3),  # 10
  (0.6, 0.0, 0.3),  # 11
]

# "R" faces using vertex indicies
faceIndices = [
  [0, 1, 2, 3, 4, 5],      # bottom face
  [6, 7, 8, 9, 10, 11],    # top face
  [0, 1, 7, 6],            # side 1
  [1, 2, 8, 7],            # side 2
  [2, 3, 9, 8],            # side 3
  [3, 4, 10, 9],           # side 4
  [4, 5, 11, 10],          # side 5
  [5, 0, 6, 11],           # side 6
]


# --------------------------------------
fig = plt.figure()
ax = fig.add_subplot(111, projection='3d')

# Dotted axis lines
axisRange = [-3.5, 3.5]
ax.plot(axisRange, [0, 0], [0, 0], 
               color='gray', ls='dotted')  # X axis
ax.plot([0, 0], axisRange, [0, 0], 
               color='gray', ls='dotted')  # Y axis
ax.plot([0, 0], [0, 0], axisRange, 
               color='gray', ls='dotted')  # Z axis

# axis labels and limits
ax.set_xlabel('X')
ax.set_ylabel('Y')
ax.set_zlabel('Z')

ax.set_xlim(-3, 3)
ax.set_ylim(-3, 3)
ax.set_zlim(-3, 3)
ax.set_box_aspect([1, 1, 1])


# two rotations, scale, translate
mats = [transMat(-1, 1, -3), scaleMat(4,4,4), 
        rotZMat(30), rotXMat(90)]
mat = multMatsList(mats)
nVerts = [applyMat(mat, vert) for vert in verts]
'''
# do nothing
nVerts = [applyMat(identMat(), vert) for vert in verts]
'''

# build "R" poly, and show
faces = [[nVerts[i] for i in face] 
                    for face in faceIndices]
poly = Poly3DCollection(faces, facecolors='skyblue', 
           linewidths=1, edgecolors='black', alpha=0.95)
ax.add_collection3d(poly)

plt.show()



