
# imPlot.py
# Andrew Davison, ad@coe.psu.ac.th, April 2025
'''
Load a picture, display it and a copy
that is reflected, rotated, then translated

Affine transform of an image
https://matplotlib.org/stable/gallery/images_contours_and_fields/affine_image.html
'''

import matplotlib.pyplot as plt
import matplotlib.image as mpimg
from matplotlib.transforms import Affine2D


_, ax = plt.subplots()

im = mpimg.imread('cat.png')  # load image
height, width = im.shape[0], im.shape[1]

size =  max(height, width)*2
ax.set_xlim(0, size)
ax.set_ylim(0, size)

# equal grid spacing
ax.set_aspect('equal')
spacing = 50 
xTicks = range(0, size + 1, spacing)
yTicks = range(0, size + 1, spacing)
ax.set_xticks(xTicks)
ax.set_yticks(yTicks)
ax.grid(True)

ax.imshow(im)
  # the image has its (0,0) at the top-left so is displayed inverted

# reflect a copy in x-axis (using scale), rotate then translate
show2 = ax.imshow(im.copy())    # show than transform
trans = Affine2D().scale(1, -1).rotate_deg(30).translate(width, height)
show2.set_transform(trans + ax.transData)

plt.show()
