
# sylvester.py
'''
  estimates probability 4 random points form n quadrilateral.

  The four points are chosen randomly within the unit circle.
  
  Paul Nahin,
  Digital Dice: Computational Solutions to Practical Probability Problems,
  Princeton, 2008,
  Intro p.21

  https://mathworld.wolfram.com/SylvestersFour-PointProblem.html
'''

import math, random

from point import Point
from convexHull import *


NUM_ITERS = 10000


n = 0

for k in range(NUM_ITERS):
  pts = []
  for j in range(4):
    r = math.sqrt(random.random())
    angle = 2.0 * math.pi * random.random()
    x = r * math.cos(angle)
    y = r * math.sin(angle)
    pts.append(Point(x,y))

  if isConvex(pts):
    # print(len(convexHull(pts)))
    if len(convexHull(pts)) == 5:  # 4 sides
      n += 1
  
print('Estimated concaves prob:', 1-(n /NUM_ITERS))
print('Expected value:', 1- (35/(12*(math.pi**2))))
