
# shoelace.py
# https://code.activestate.com/recipes/578047-area-of-polygon-using-shoelace-formula/

# Area of Polygon using Shoelace formula
# http://en.wikipedia.org/wiki/Shoelace_formula
# FB - 20120218
# pts must be ordered in clockwise or counter-clockwise direction

import matplotlib.pyplot as plt
from point import Point
from GeomTools import *



def polyArea(pts):
  n = len(pts) # of pts
  area = 0.0
  for i in range(n):
    j = (i + 1) % n
    area += pts[i].x * pts[j].y
    area -= pts[j].x * pts[i].y
  return abs(area)/2


# -------------------------------

if __name__ == "__main__":

  pts = [Point(2.0, 1.0), Point(4.0, 5.0), Point(7.0, 8.0)]
  print(*pts)
  print("Area:", polyArea(pts))
  
  print()
  pts = [Point(3.0, 4.0), Point(5.0, 11.0), Point(12.0, 8.0), Point(9.0, 5.0), Point(5.0, 6.0)]
  print(*pts)
  print("Area:", polyArea(pts))

  graphing(size=15)
  drawPoly(pts)
  plt.show()

