
# nearestPts.py

# Compute the distance between two pts (x1, y1) and (x2, y2)
def distance(x1, y1, x2, y2):
  return ((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1)) ** 0.5

def nearestPoints(pts):
  # p1 and p2 are the indices in the pts list
  p1, p2 = 0, 1  # Initial two pts

  minDist = distance(pts[p1][0], pts[p1][1], 
                     pts[p2][0], pts[p2][1]) 
  
  # Compute distance for every two pts
  for i in range(len(pts)):
    for j in range(i + 1, len(pts)):
      d = distance(pts[i][0], pts[i][1], 
               pts[j][0], pts[j][1])  # Find distance
      if minDist > d:
        p1, p2 = i, j 
        minDist = d 

  return p1, p2 # Return p1 and p2


# ------- main ----------

points = [[0, 0], [9, 9], [-1, 0], [-1, -1], [4, 1], [4, 5], [3, 1],
          [2, 0.5], [3.5, 2], [3, 1.5], [-1.5, 4], [5.5, 4]]

p1, p2 = nearestPoints(points)
print("The closest two points are " + 
                    str(points[p1]) + " and " + str(points[p2]))


