
# GeomTools.py

import math
import matplotlib.pyplot as plt

# from point import Point
from segment import Segment
# from vector import Vector


# -------------------- drawing -------------------

def graphing(size=10):
  # plot like graph paper showing positive axis up to size
  plt.xlim(0)
  plt.ylim(0)
  if size < 30:
    majors = range(0,size+1,1)
  elif size < 80:
    majors = range(0,size+1,5)
  else:
    majors = range(0,size+1,10)

  plt.xticks(majors)
  plt.yticks(majors)
  ax = plt.gca()
  ax.grid(which="both")
  ax.set_aspect("equal")


def drawPoly(pts):
  segs = []
  for i in range(len(pts)-1):
    segs.append( Segment( pts[i], pts[i+1]))
  segs.append( Segment(pts[len(pts)-1], pts[0]))
  for seg in segs:
    seg.draw()


