
# bifurcation.py
# https://en.wikipedia.org/wiki/Logistic_map
# https://ipython-books.github.io/121-plotting-the-bifurcation-diagram-of-a-chaotic-dynamical-system/


import math
import matplotlib.pyplot as plt
from frange import *

NUM_RS = 10000   # more r detail when zoomed-in
NUM_ITERS = 500

def logistic(r, x):
	return r * x * (1 - x)

def logistics(r):
  xs = [0.1]
  for i in range(NUM_ITERS-1):
    xs.append(logistic(r,xs[i]))
  return xs[NUM_ITERS-100:]     #  last 100 iterations

rs = linspace(2.0, 4.0, NUM_RS)  # r between 2 and 4
xVals = []
rVals = []
for r in rs:
  xs = logistics(r)
  xVals.append(xs)
  rVals.append([r] * 100) 
plt.figure(figsize=(10, 5)) 
plt.scatter(rVals, xVals, s=0.1)
plt.xlabel('r')
plt.ylabel('x')
plt.xlim(2.5, 4)
plt.title("Bifurcation Diagram for the Logistic Map")
plt.show()