
# eatenPhases.py

'''
Plot solutions as orbits in phase space, without representing time, but with one axis representing the number of prey and the other axis representing the densities of predators for all times. 
'''

import math
import matplotlib.pyplot as plt 
from frange import *

looselyDashed = (0, (5, 10))
# birth/death rate of prey (hares)
alpha = 2 
beta =  2 
# birth/death rate of predators (foxes)
delta = 1 
gamma = 1

'''
  Reduce dt and N_T by factor of 10 to reduce accuracy
'''
dt  = 0.001
N_t = 20000   # no of steps

def plotSpace(pop, linestyle):
  preds = [0]*N_t
  prey = [0]*N_t
  coords = []
  prey[0] = pop
  preds[0] = pop
  
  for i in range(N_t-1):
    prey[i+1] = prey[i] + dt*alpha*prey[i] - \
                          dt*beta*prey[i]*preds[i]
  
    preds[i+1] = preds[i] + dt*delta*prey[i]*preds[i] - \
                            dt*gamma*preds[i]
    if i % int(N_t/7) == 0:
      coords.append((prey[i+1], preds[i+1]))
  
  
  plt.plot(prey, preds, label="pop="+str(pop), ls=linestyle) 
  
  xc, yc = zip(*coords)
  plt.scatter(xc, yc)
  for i in range(len(xc)):
    plt.text(xc[i], yc[i], " "+str(i), 
                            ha='left', va='center')

# population densities
plotSpace(0.25, 'dotted')
plotSpace(0.5, looselyDashed)
plotSpace(0.75, 'solid')

plt.xlabel('Prey')
plt.ylabel('Preds')
plt.legend()
plt.title("Phase Spaces for Prey/Preds Pop.")
plt.show() 
