
# school.py

import matplotlib.pyplot as plt
from frange import *

# Time unit: 1 hour
beta = 10/(40*8*24)    # 10
   # reduce beta to reduce outbreak rate (e.g. to 2)
gamma = 3/(15*24)

dt = 0.1             # 6 min
D = 30               # Simulate for D days
N_t = int(D*24/dt)   # Corresponding no of steps

ts = linspace(0, N_t*dt, N_t+1)
S = [0]*(N_t+1)
I = [0]*(N_t+1)
R = [0]*(N_t+1)

# Initial conditions
S[0] = 50
I[0] = 1
R[0] = 0

# Step equations forward in time
for n in range(N_t):
  S[n+1] = S[n] - dt*beta*S[n]*I[n]
  I[n+1] = I[n] + dt*beta*S[n]*I[n] - dt*gamma*I[n]
  R[n+1] = R[n] + dt*gamma*I[n]

plt.plot(ts, S, label="S")
plt.plot(ts, I, label="I")
plt.plot(ts, R, label="R")
plt.legend()
plt.xlabel('hours')
plt.ylabel('people')
plt.title("School flu over " + str(D) + " days")
plt.show()
