
# Mice.py

import math
from turtle import *
from TurtleUtils import *

EPS = 12

def init(col, x, y):
  t = Turtle()
  t.speed(0)
  # t.width(5)
  t.color(col)
  gotoUp(t, x, y)
  return t


def move(t, pos, step):
  angle = t.towards(pos)
  t.setheading(angle)   # Set the direction with this angle
  t.fd(step)


def drawLineTo(t, p):
  # draw a line to p then return to original pos
  pos = t.position()
  t.hideturtle()
  t.goto(p)  
  t.goto(pos)
  t.showturtle()


def isClose(p1, p2):
  return abs( math.dist(p1,p2)) < EPS


# ---------------- main -----------------

t1 = init('red', -200, -200)
t2 = init('blue', 200, -200)
t3 = init('orange', 200, 200)
t4 = init('green', -200, 200)

start1 = t1.pos()
start2 = t2.pos()
start3 = t3.pos()
start4 = t4.pos()

numSteps = 0
while True:
  pos1 = t1.pos()
  pos2 = t2.pos()
  pos3 = t3.pos()
  pos4 = t4.pos()
  if isClose(pos1, pos2):
    break
  
  # draw lines between turtle positions
  drawLineTo(t1, pos2) 
  drawLineTo(t2, pos3) 
  drawLineTo(t3, pos4) 
  drawLineTo(t4, pos1) 
  
  # move 10 units towards those positions
  move(t1, pos2, 10)
  move(t2, pos3, 10)
  move(t3, pos4, 10)
  move(t4, pos1, 10)
  numSteps += 1

end1 = t1.pos()
print("Travel Dist:", numSteps*10)

exitonclick()



