
# dogDuck.py
# input: 5  or 5.2


import math
from turtle import Turtle
from TurtleUtils import *

EPS = 20
RADIUS = 200
DUCK_STEP = 5


def isClose(p1, p2):
  return abs( math.dist(p1,p2)) < EPS


def move(t, pos, step):
  angle = t.towards(pos)
  t.setheading(angle)   # Set the direction with this angle
  t.fd(step)


dogStep = float(input("Dog step? "))

circum = 2*math.pi*RADIUS
duckAngle = DUCK_STEP/circum*360

duck = Turtle()
duck.hideturtle()
duck.speed(0)
scr = duck.getscreen()
scr.title('Dog and Duck')
scr.addshape("duck.gif")
scr.addshape("dog.gif")

duck.pencolor("blue")   # draw axes
drawLine(duck, -250, 0, 250, 0)
drawLine(duck, 0, -250, 0, 250)
duck.pencolor("black")

dog = Turtle()  # position dog
dog.speed(0)
dog.shape("dog.gif")
dog.pencolor("red")

gotoUp(duck, 0, -RADIUS)  # position duck
duck.shape("duck.gif")
duck.showturtle()

numSteps = 0
while True:
  duck.circle(RADIUS, duckAngle)

  duckPos = duck.pos()
  move(dog, duckPos, dogStep)

  numSteps += 1
  dogPos = dog.pos()
  if isClose(duckPos, dogPos):
    break

print("No. steps:", numSteps)
scr.exitonclick()
