
# vectorgram.py
'''
  Inspired by the vectorgram visualization in:
  "Wonders of Numbers", Clifford A. Pickover, OUP, 2001
  Chapter 55, Audioactive Decay, p.134-138
'''

import math, turtle

def vectorgram(digs, numDirs, size):
  t = turtle.Turtle()
  t.hideturtle()
  t.speed("fastest")
  scr = t.screen
  scr.title('Vectorgram')
  vgDraw(t, digs, numDirs, size)
  print("Finished drawing")
  scr.exitonclick()



def vgDraw(t, digs, numDirs, size):
  angleIncr = 360/numDirs

  for ch in digs:
    if ch.isdigit():
      angle = (int(ch)%numDirs)*angleIncr
      t.setheading(angle)
      t.forward(size)


# ----------------------------------

if __name__ == "__main__":
  vectorgram("00000111112222", 3, 10)
