
# rarctanPi.py

import math, time, sys
import decimal
from decimal import Decimal as D


def rarctan(r, a, n=100):
  # calculates r*arctan(1/a) using n iterations
  return s(r, a, 2*n+1)

def s(r, a, n):
  if n == -1:
    return D(0)
  else:
    return s(r, a, n-2) + u(r, a, n)

def u(r, a, n):
  if n == -1:
    return r*a
  else:
    return -u(r, a, n-2)*(n-2)/(n*a**2)


sys.setrecursionlimit(10**6)
decimal.getcontext().prec = 100

start = time.time()
print("\n Machin:", 
  rarctan(D(16),D(5)) - rarctan(D(4),D(239)))
print(f"Elapsed time: {(time.time() - start):.3f} secs")

start = time.time()
print("\nStormer:", 
   rarctan(D(24),D(8)) + rarctan(D(8),D(57)) + 
                         rarctan(D(4),D(239)))
print(f"Elapsed time: {(time.time() - start):.3f} secs")

start = time.time()
print("\n  Gauss:", 
  rarctan(D(48),D(18)) + rarctan(D(32),D(57)) - 
                         rarctan(D(20),D(239)))
print(f"Elapsed time: {(time.time() - start):.3f} secs")

