
# plotexpD.py
'''
  Two graphs for expD(1) run with different digit
  precisions (ds). The left hand graph plots ds against
  running time (in secs) using log scales. The second
  graph shows d against no. of iterations of the code.
'''

import matplotlib.pyplot as plt

ds = [  1000, 10000,  100000,   300000,   500000,   1000000 ]
tms = [0.040, 4.111, 242.395, 1844.301, 5688.023, 22623.750 ]
steps = [ 451, 3250,   25207,    68191,   108654,    205023 ]
''' 
  this data was obtained by running expD.py six times with
  the different ds digit precisions
'''

fig, ax = plt.subplots(1, 2, figsize=(10,5))
                  # row x column
fig.tight_layout(pad=5.0)
fig.suptitle("expD(1)")

# left-hand time plot
ax[0].scatter(ds, tms)
ax[0].set_xlabel("Digit precision")
ax[0].set_ylabel("secs")
ax[0].set_xscale("log")
ax[0].set_yscale("log")

# right-hand iterations plot
ax[1].scatter(ds, steps)
ax[1].set_xlabel("Digit precision")
ax[1].set_ylabel("iterations")

plt.show()