
# pippen.py
# input: 1000
'''
  Nicholas Pippenger, An infinite product for e, The American Mathematical Monthly, Vol. 87, No. 5 (1980), p. 391.

  https://oeis.org/A084149
'''

import math, time


def numer(n):
  if n == 2:
    yield 2
  else:
    start = n//2
    yield start
    mid = start + 2
    i = 1
    for i in range(1, start-1, 2):
      yield mid
      yield mid
      mid += 2
    yield n 

def denom(n):
  if n == 2:
    yield 1
  else:
    start = n//2
    elem = start + 1
    for i in range(0, start, 2):
      yield elem
      yield elem
      elem += 2

def pipTerm(n):
  numGen = numer(n)
  denGen = denom(n)
  frac = 1
  for i in range(n//2):
    frac = frac * next(numGen)/next(denGen)
  return frac**(1/n)


n = int(input("No. terms? "))
startTime = time.time()
tot = 1
for i in range(1, n):
  tot *= pipTerm(2**i)
estE = tot*2
endTime = time.time() - startTime

print(" est e:", estE)
print(f"Elapsed time: {endTime:.3f} secs")
print("math.e:", math.e)