
# normalNum.py
# input: pi10000.txt  e10000.txt
'''
   Load the number stored in fnm, and count
   their digits. This is to observe if the number is a 
   Normal number (i.e. its digits are distributed
   uniformly). The counts are plotted as bars, with the
   mean and stdev shown as lines over the bars.

   https://en.wikipedia.org/wiki/Normal_number
   https://mathworld.wolfram.com/NormalNumber.html

   The digit spread is also displayed as a vectorgram,
   inspired by John Venn's "The Logic of Chance", 
'''

import re
from decTrig import *
from statistics  import mean, stdev
import matplotlib.pyplot as plt
from vectorgram import *


def loadNumStr(fnm):
  f = open(fnm, 'r')
  print("Reading number from", fnm)
  lines = f.readlines()
  spacePat = re.compile(r'\s+')
  numStr = ""
  for line in lines:
    if not line.startswith("#"):
      numStr += re.sub(spacePat, '', line)
  
  print("Length:", len(numStr))
  return numStr


fnm = input("fnm? ")
ns = loadNumStr(fnm)
print("\nCounts of digits:")
tots = countDigits(ns)
print(tots)

mean = mean(tots)
stdev = stdev(tots)
print(f"Mean: {mean:.1f}; stdev: {stdev:.1f}")

plt.bar(range(10), tots)
plt.axhline(y = mean, color = 'g', linestyle = '-') 
plt.axhline(y = mean+stdev, color = 'r', linestyle = '--') 
plt.axhline(y = mean-stdev, color = 'r', linestyle = '--') 
plt.title("Digits count of " + fnm)
plt.show()

vectorgram(ns, 10, 5)
