
# sticks.py

import random

NUM_TRIALS = 100000

def isTriangle(a, b, c):
  return (a + b > c) and (a + c > b) and (b + c > a)

numTris = 0
for i in range(NUM_TRIALS):
  x = random.uniform(0, 1)
  y = random.uniform(0, 1)   # 1st scenario
  # y = random.uniform(x, 1)  # 2nd scenario
  if x > y:
    x, y = y, x
  if isTriangle(x, y-x, 1-y):
    numTris += 1
print(f"Estimated prob = {(numTris/NUM_TRIALS):0.6f}")