
# friends.py

import math, random
import matplotlib.pyplot as plt
from frange import *

N   = 40000 # number of events

# generate N events of friends times
met, notMet = [], []
for i in range(N):
  friend1 = random.random()
  friend2 = random.random()
  if abs(friend2-friend1) < 1/6:  # 10 mins
    met.append((friend1, friend2))
  else:
    notMet.append((friend1, friend2))


# plot the result, this might shed some light on the problem!
plt.plot(*zip(*met), 'y+', mec='y')
plt.plot(*zip(*notMet), 'bo', mec='b')

plt.title("Probability of meeting: %1.3f" % (float(len(met))/N))
plt.xlabel('Time of arrival of Friend 1 [minutes]')
plt.ylabel('Time of arrival of Friend 2 [minutes]')
plt.xticks([n/6 for n in range(7)], [n*10 for n in range(7)])
plt.yticks([n/6 for n in range(7)], [n*10 for n in range(7)])
plt.axis('scaled')

plt.show()
