
# rWalk3D.py

import random
import matplotlib.pyplot as plt


def rWalk1D(n):
  x = 0; xs = [x]
  y = 0; ys = [y]
  z = 0; zs = [z]
  for _ in range(1, n+1):
    x += random.choice([-1,0,1])
    xs.append(x)
    y += random.choice([-1,0,1])
    ys.append(y)
    z += random.choice([-1,0,1])
    zs.append(z)
  return xs, ys, zs


ax = plt.figure().add_subplot(projection ='3d')

xs, ys, zs = rWalk1D(1000)
plt.plot(xs, ys, zs, 'r-')

plt.xlabel('x')
plt.ylabel('y')
ax.set_zlabel('z')   # no plt.zlabel()
plt.title("3D Random Walk")
plt.show()