
# rWalk1D.py

import random
import matplotlib.pyplot as plt


def rWalk1D(n):
  ts = [0]
  y = 0
  locs = [y]
  for i in range(1, n+1):
    ts.append(i)
    y += random.choice([-1,1])
    locs.append(y)
  return ts, locs

ts, locs = rWalk1D(1000)
plt.plot(ts, locs, 'r-')
plt.axhline(0)
plt.xlabel('time')
plt.ylabel('y')
plt.title("1D Random Walk")
plt.show()