
# siamese.py
# https://en.wikipedia.org/wiki/Siamese_method
# construct an odd magic square
# input: 3 or 5 or 7 or 19

def siamese(square, n):
  row = 0
  col = int((n + 1) / 2 - 1)
  square[row][col] = 1  # center cell of top row

  for i in range(2, n * n + 1):
    rowPrev = row
    colPrev = col

    # move to the NE cell modulo the square size;
    # or drop down 1 cell if that spot is occupied
    row = (row - 1) % n
    col = (col + 1) % n
    while square[row][col] != 0:  # cell is occupied
      row = (rowPrev + 1) % n
      col = colPrev
    square[row][col] = i


n = int(input("n? "))
if n % 2 == 0:
  print("Square side size should be odd!")
else:
  # square[row][col]
  square = [[0 for col in range(n)] for row in range(n)]
  siamese(square, n)

  width = len(str(n*n)) + 1  # space required for printing
  for row in square:
    for el in row:
      print(f"{el:{width}d}", end='')
    print()

