
# evenOrderMagic.py
# generate a 4 by 4 magic square.
# Invitation to number theory with Pascal, 
# Donald D Spencer
# input: 4

n = int(input("n? "))
if n%2 == 1:
  n += 1  
# size of magic square

# sqr[r][c]
sqr = [[0 for c in range(n)] for r in range(n)]

# Store 999 in each cell of diagonal 1
for i in range(n):
  sqr[i][i] = 999

# Store 999 in each cell of diagonal 2
for i in range(n):
  j = n-1 - i
  sqr[i][j] = 999

# First pass
k = 1
for i in range(n):
  for j in range(n):
    if sqr[i][j] == 0:
      sqr[i][j] = k
    k += 1

# Second pass
k = n * n
for i in range(n):
  for j in range(n):
    if sqr[i][j] == 999:
      sqr[i][j] = k
    k -= 1

# Print magic square
for i in range(n):
  for j in range(n):
    print(f"{sqr[i][j]:3d}", end=' ')
  print()
