
# jacobi.py
# https://en.wikipedia.org/wiki/Jacobi%27s_four-square_theorem
# input: 5

'''
Jacobi's four-square theorem gives a formula for the number of ways that a given positive integer n can be represented as the sum of four squares (of integers). 

The number of ways of writing n as a sum of 4 squares is 8 times the sum of divisor of n if n is odd and is 24 times the sum of odd divisor of n if n is even.

Find the sum of odd and even divisor of n by running a loop from 1 to sqrt(n) .

https://oeis.org/A000118
'''

import math


def divisors(n):
  divs = [1]
  for i in range(2,int(math.sqrt(n))+1):
    if n%i == 0:
      divs.extend([i, n//i])
  divs.extend([n])
  divs = list(set(divs))
  divs.sort()
  return divs


def sumDivisors(n):
  oddsSum = 0
  evensSum = 0
  for i in range(1, int(math.sqrt(n))+1):
    if n%i == 0:   # i is a factor of n
      if i%2 == 0:
        evensSum += i
      else:
        oddsSum += i
      # n/i is also a factor
      if n//i != i:
        if (n//i)%2 == 0:
          evensSum += (n//i)
        else:
          oddsSum += (n//i)
  if n%2 == 1:  # odd
    return 8*(oddsSum + evensSum)
  else:
    return 24*oddsSum


n = int(input("n? "))
for i in range(n):
  print(i, ":", divisors(i), ";", sumDivisors(i))
