
# sacksSpiral.py
'''
https://numberspiral.com/index.html
https://sevko.io/articles/prime-number-spirals/
https://en.wikipedia.org/wiki/Archimedean_spiral
'''

import math
from turtle import Turtle
from prime import *

SZ = 500
MAX_NUM = 15000

def spiral(t):
  for i in range(0, MAX_NUM):
    dist = math.sqrt(i)
    angle = math.radians(360 * dist)
    radius = dist * 2
    x = math.cos(angle) * radius
    y = math.sin(angle) * radius
    t.goto(x,y)
    # if math.isqrt(i)**2 == i:
    if isPrime(i):
      t.dot(3)

t = Turtle()
t.speed(0) 
t.hideturtle()
t.pencolor("blue")
t.penup()
scr = t.getscreen()
scr.screensize(SZ, SZ)
scr.setup(SZ+40, SZ+40)
scr.delay(0)
scr.title("Sacks spiral")
spiral(t)
print("finished")
scr.exitonclick()
