
# countPlot.py
# info: https://en.wikipedia.org/wiki/Prime_number_theorem

import math
import matplotlib.pyplot as plt
from prime import *

MAX = 5000002
STEP = 10000

prims = sievePrimes(MAX)
xs = []
ps = []
count = 0
for x in range(2, MAX, STEP):
  xs.append(x)
  a = x
  while a < x+STEP:
    if prims[a]:
      count += 1
    a += 1
  ps.append(count/(a/math.log(a)))
plt.plot(xs, ps)
plt.title("count/(x/ln x)")
plt.show()
